# Copyright (C) 2013-2019 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 17-Aug-2019 06:56.

"""nodeModel userdefined profile, originally defined in resource file set
apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.count_32
import izot.resources.datapoints.switch
import izot.resources.datapoints.count
import P9000010600000000_4.datapoints.dataAll
import izot.resources.properties.maxSendTime
import izot.resources.properties.maxRcvTime
import izot.resources.properties.delayTime
import izot.resources.properties.masterSlave


class nodeModel(izot.resources.base.Profile):
    """nodeModel userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20002,
            scope=4
        )
        self.datapoints['nviDataSeed'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  A 32-bit counter.""",
            name='nviDataSeed',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.count_32.count_32,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoCount1'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  A 32-bit counter.""",
            name='nvoCount1',
            profile=self,
            number=2,
            datatype=izot.resources.datapoints.count_32.count_32,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoCount2'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  A 32-bit counter.""",
            name='nvoCount2',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.count_32.count_32,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoCount3'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  A 32-bit counter.""",
            name='nvoCount3',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.count_32.count_32,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoCount4'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  A 32-bit counter.""",
            name='nvoCount4',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.count_32.count_32,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nviEnable'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch """,
            name='nviEnable',
            profile=self,
            number=7,
            datatype=izot.resources.datapoints.switch.switch,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.INPUT
        )
        self.datapoints['nvoFaults'] = izot.resources.base.Profile.DatapointMember(
            doc="""Absolute count.  """,
            name='nvoFaults',
            profile=self,
            number=8,
            datatype=izot.resources.datapoints.count.count,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoCounterData'] = izot.resources.base.Profile.DatapointMember(
            doc=""" """,
            name='nvoCounterData',
            profile=self,
            number=9,
            datatype=P9000010600000000_4.datapoints.dataAll.dataAll,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['cpMaxSendTime'] = izot.resources.base.Profile.PropertyMember(
            doc="""Maximum send time.  The maximum period of time between
            consecutive transmissions of the current value.""",
            name='cpMaxSendTime',
            profile=self,
            number=1,
            datatype=izot.resources.properties.maxSendTime.maxSendTime,
            default=b'\x02\x58',
            mandatory=True
        )
        self.properties['cpMaxRcvTime'] = izot.resources.base.Profile.PropertyMember(
            doc="""Maximum receive time.  The maximum period of time that may
            expire with no updates on the associated input network variables
            before the object goes into heartbeat failure mode.  A zero value
            disables the mechanism.""",
            name='cpMaxRcvTime',
            profile=self,
            number=2,
            datatype=izot.resources.properties.maxRcvTime.maxRcvTime,
            default=b'\x03\x20',
            mandatory=True
        )
        self.properties['cpRandDelay'] = izot.resources.base.Profile.PropertyMember(
            doc="""Delay time, default to scene.  The delay time, default to
            scene.""",
            name='cpRandDelay',
            profile=self,
            number=3,
            datatype=izot.resources.properties.delayTime.delayTime,
            minimum=b'\x00\x64',
            default=b'\x00\x00',
            mandatory=True
        )
        self.properties['cpIsMaster'] = izot.resources.base.Profile.PropertyMember(
            doc="""Master-slave operation.  Used to select master clock or
            slave clock, non-zero indicates this is master clock.""",
            name='cpIsMaster',
            profile=self,
            number=4,
            datatype=izot.resources.properties.masterSlave.masterSlave,
            default=b'\x00',
            mandatory=True
        )
        self._original_name = 'UFPTnodeModel'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = nodeModel()
    pass
